import pandas as pd   
import pickle
   
# Assuming the filtered dataset is loaded as a DataFrame named 'filtered_fastfood'

# Normalize the nutrient values using min-max normalization
def normalize(column):
    return (column - column.min()) / (column.max() - column.min())
 
filtered_fastfood['protein_norm'] = normalize(filtered_fastfood['protein'])
filtered_fastfood['fiber_norm'] = normalize(filtered_fastfood['fiber'])
filtered_fastfood['vit_a_norm'] = normalize(filtered_fastfood['vit_a'])
filtered_fastfood['vit_c_norm'] = normalize(filtered_fastfood['vit_c'])
filtered_fastfood['calcium_norm'] = normalize(filtered_fastfood['calcium'])
filtered_fastfood['sat_fat_norm'] = normalize(filtered_fastfood['sat_fat'])
filtered_fastfood['trans_fat_norm'] = normalize(filtered_fastfood['trans_fat'])
filtered_fastfood['sugar_norm'] = normalize(filtered_fastfood['sugar'])
filtered_fastfood['sodium_norm'] = normalize(filtered_fastfood['sodium'])
filtered_fastfood['total_carb_norm'] = normalize(filtered_fastfood['total_carb'])
 
# Calculate the health score using the normalized values
filtered_fastfood['health_score'] = (filtered_fastfood['protein_norm'] + filtered_fastfood['fiber_norm'] + filtered_fastfood['vit_a_norm'] + filtered_fastfood['vit_c_norm'] + filtered_fastfood['calcium_norm']) - (filtered_fastfood['sat_fat_norm'] + filtered_fastfood['trans_fat_norm'] + filtered_fastfood['sugar_norm'] + filtered_fastfood['sodium_norm'] + filtered_fastfood['total_carb_norm'])
 
print(filtered_fastfood)
pickle.dump(filtered_fastfood,open("./ref_result/filtered_fastfood.pkl","wb"))
